﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for SalesMovementReport.xaml
    /// </summary>
    public partial class SalesMovementReport : Page
    {
        public SalesMovementReport()
        {
            InitializeComponent();
            LoadReport();
        }
        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvLowStockReport, "SalesMovementReport");
        }
        private void LoadReport()
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                List<Products> ProductList = ProductsBL.GetList(Guid.Empty, string.Empty);
                ProductList = (from pb in ProductList
                               where pb.IsActive
                               orderby pb.ActualStock ascending
                               select pb).ToList<Products>();
                gvLowStockReport.Dispatcher.BeginInvoke((Action)(() => gvLowStockReport.ItemsSource = ProductList.Take(20)));
            });
        }
    }
}
